'use strict'

// Performance Report Chart
var options = {
  series: [{
  name: 'Designing',
  data: [44, 55, 41, 67, 22, 43, 44]
  }, {
    name: 'Development',
    data: [13, 23, 20, 8, 13, 27, 13]
  }, {
    name: 'SEO',
    data: [11, 17, 15, 15, 21, 14, 11]
  }],
    chart: {
    type: 'bar',
    height: 310,
    stacked: true,
    toolbar: {
      show: false
    },
    zoom: {
      enabled: true
    }
  },
  grid: {
    borderColor: "rgba(107 ,114 ,128,0.1)",
  },
  responsive: [{
    breakpoint: 480,
    options: {
      legend: {
        position: 'bottom',
        offsetX: -10,
        offsetY: 0
      }
    }
  }],
  colors: ["#5a66f1","#60a5fa", "#d5dde7" ],
    legend: {
        show: true,
        borderRadius: 5,
        position: 'top'
    },
    plotOptions: {
        bar: {
            columnWidth: "20%",
            borderRadius: 5
        }
  },
  dataLabels: {
    enabled: false
  },
  xaxis: {
    categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul'],
  },
  fill: {
    opacity: 1
  }
};

var chart1 = new ApexCharts(document.querySelector("#performanceReport"), options);
chart1.render();

function performanceReport(){
	chart1.updateOptions({
		colors:["rgb(" + myVarVal + ")", "#60a5fa","#d5dde7"]
  })
}





// Sessions By Device Chart
var options = {
  series: [1754, 1234, 878, 270],
  labels: ["Mobile", "Tablet", "Desktop", "Others"],
  chart: {
    height: 325,
    type: "donut",
  },
  dataLabels: {
    enabled: false,
  },

  legend: {
    position: "bottom",
    horizontalAlign: "center",
    fontSize: "15px",
    fontWeight: 500,
    labels: {
      color: ["rgb(100, 116, 139)"],
    },
  },
  stroke: {
    show: true,
    curve: "smooth",
    lineCap: "round",
    colors: "#fff",
    width: 0,
    dashArray: 0,
  },
  grid: {
    borderColor: "rgba(107 ,114 ,128,0.1)",
  },
  plotOptions: {
    pie: {
      expandOnClick: false,
      donut: {
        size: "80%",
        background: "transparent",
        labels: {
          show: true,
          name: {
            show: true,
            fontSize: "20px",
            color: "#495057",
            offsetY: -4,
          },
          value: {
            show: true,
            fontSize: "32px",
            fontWeight: 600,
            offsetY: 8,
            formatter: function (val) {
              return val + "%";
            },
          },
          total: {
            show: true,
            showAlways: true,
            label: "Total",
            fontSize: "25px",
            color: "rgb(100, 116, 139)",
          },
        },
      },
    },
  },
  colors: [
    "rgba(90,102,241, 1)",
    "rgba(96,165,250, 1)",
    "rgba(234,179 ,8, 1)",
    "rgba(203,213,225, 1)",
  ],
};
document.querySelector("#sessionsx").innerHTML = " ";
var chart = new ApexCharts(document.querySelector("#sessionsx"), options);
chart.render();

function Sessions() {
  chart.updateOptions({
    colors: [
      "rgba(" + myVarVal + ", 1)",
      "rgba(96,165,250, 1)",
      "rgba(234,179 ,8, 1)",
      "rgba(203,213,225, 1)",
    ],
  });
}